import { jsx, jsxs } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import { memo } from "react";
import { PORTRAIT_BREAKPOINT } from "../../constants.mjs";
import { useBreakpoint } from "../../context/breakpoints.mjs";
import { useReadonly } from "../../hooks/useReadonly.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
import {
  TldrawUiPopover,
  TldrawUiPopoverContent,
  TldrawUiPopoverTrigger
} from "../primitives/TldrawUiPopover.mjs";
import { TldrawUiMenuContextProvider } from "../primitives/menus/TldrawUiMenuContext.mjs";
import { DefaultActionsMenuContent } from "./DefaultActionsMenuContent.mjs";
const DefaultActionsMenu = memo(function DefaultActionsMenu2({
  children
}) {
  const msg = useTranslation();
  const breakpoint = useBreakpoint();
  const isReadonlyMode = useReadonly();
  const editor = useEditor();
  const isInAcceptableReadonlyState = useValue(
    "should display quick actions when in readonly",
    () => editor.isInAny("hand", "zoom"),
    [editor]
  );
  const content = children ?? /* @__PURE__ */ jsx(DefaultActionsMenuContent, {});
  if (isReadonlyMode && !isInAcceptableReadonlyState) return;
  return /* @__PURE__ */ jsxs(TldrawUiPopover, { id: "actions-menu", children: [
    /* @__PURE__ */ jsx(TldrawUiPopoverTrigger, { children: /* @__PURE__ */ jsx(
      TldrawUiButton,
      {
        type: "icon",
        "data-testid": "actions-menu.button",
        title: msg("actions-menu.title"),
        children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "dots-vertical", small: true })
      }
    ) }),
    /* @__PURE__ */ jsx(
      TldrawUiPopoverContent,
      {
        side: breakpoint >= PORTRAIT_BREAKPOINT.TABLET ? "bottom" : "top",
        sideOffset: 6,
        children: /* @__PURE__ */ jsx("div", { className: "tlui-actions-menu tlui-buttons__grid", "data-testid": "actions-menu.content", children: /* @__PURE__ */ jsx(TldrawUiMenuContextProvider, { type: "icons", sourceId: "actions-menu", children: content }) })
      }
    )
  ] });
});
export {
  DefaultActionsMenu
};
//# sourceMappingURL=DefaultActionsMenu.mjs.map
